/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * \file    DM388_EVM.h
 *
 * \brief   Defines the SoC specific memory Maps
 *
 * This header file contains the Macros definitions for SoC memory maps
 * 
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created.
 */

#ifndef _DM388_EVM_H_
#define _DM388_EVM_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM388_types.h"
#include "version.h"

/**
@addtogroup DM388 EVM
@{
*/

/*
 *====================
 * Defines
 *====================
*/

#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)

#define DDR_FREQ    800 /* user configurable values
                           800 -> 400 MHz
                           1066 -> 533 MHz */
#define HDMI_CONFIG 148 /* user configurable values ,
                            the other options are
                            148
                            186 */

#define PRCM_BASE_ADDR            0x48180000
#define DUCATI_BASE_ADDR          0x55020000
#define DUCATI_MMU_CFG            0x55080000
#define CTRL_MODULE_BASE_ADDR     0x48140000
#define PLL_BASE_ADDRESS          0x481C5000
#define CONTROL_BASE_ADDRESS      0x48140000

#define    CM_CTRL_CLKCTRL        0x481815c4

#define DMM_BASE_ADDR             0x4E000000
#define EMIF4_0_CFG_BASE_ADDR     0x4C000000
#define GPMC_MEM_BASE_ADDR        0x02000000
#define DDR_MEM_BASE_ADDR         0x80000000

#define DSS_BASE_ADDR             0x48100000
#define DSS_VENC_BASE_ADDR        (DSS_BASE_ADDR + 0x5e00)


/* Only for Centaurus  */
#define GMII_SELECT                (CTRL_MODULE_BASE_ADDR + 0x0650)
#define CM_ALWON_L3_SLOW_CLKSTCTRL (PRCM_BASE_ADDR + 0x1400)

/*DSS */
#define RM_DSS_RSTCTRL             (PRCM_BASE_ADDR + 0x0E10)
#define CM_DSS_CLKSTCTRL           (PRCM_BASE_ADDR + 0x0800)
#define CM_DSS_DSS_CLKCTRL         (PRCM_BASE_ADDR + 0x0820)
#define CM_DSS_HDMI_CLKCTRL        (PRCM_BASE_ADDR + 0x0824)


/*UART*/
#define CM_ALWON_UART_0_CLKCTRL     (PRCM_BASE_ADDR + 0x1550)
#define CM_ALWON_UART_1_CLKCTRL     (PRCM_BASE_ADDR + 0x1554)
#define CM_ALWON_UART_2_CLKCTRL     (PRCM_BASE_ADDR + 0x1558)

#define CM_DEFAULT_DUCATI_CLKSTCTRL    (PRCM_BASE_ADDR + 0x0518)
#define CM_DEFAULT_DUCATI_CLKCTRL    (PRCM_BASE_ADDR + 0x0574)
#define RM_DEFAULT_RSTCTRL        (PRCM_BASE_ADDR + 0x0B10)
#define RM_DEFAULT_RSTST        (PRCM_BASE_ADDR + 0x0B14)
#define CM_ALWON_OCMC_0_CLKSTCTRL    (PRCM_BASE_ADDR + 0x1414)
#define CM_ALWON_OCMC_0_CLKCTRL        (PRCM_BASE_ADDR + 0x15B4)
#define CM_ALWON_GPMC_CLKCTRL        (PRCM_BASE_ADDR + 0x15D0)
#define CM_ALWON_RTC_CLKSTCTRL    (PRCM_BASE_ADDR + 0x142C)
#define CM_ALWON_RTC_CLKCTRL        (PRCM_BASE_ADDR + 0x15F0)

/*IVAHD0 PRCM Definition*/

#define CM_IVAHD0_CLKSTCTRL        (PRCM_BASE_ADDR + 0x0600)
#define CM_IVAHD0_IVAHD_CLKCTRL        (PRCM_BASE_ADDR + 0x0620)
#define CM_IVAHD0_SL2_CLKCTRL        (PRCM_BASE_ADDR + 0x0624)
#define PM_IVAHD0_PWRSTST        (PRCM_BASE_ADDR + 0x0C04)
#define RM_IVAHD0_RSTCTRL        (PRCM_BASE_ADDR + 0x0C10)
#define RM_IVAHD0_RSTST                (PRCM_BASE_ADDR + 0x0C14)

/*END OF IVAHD0 PRCM Definition*/

/*ISS PRCM Definition*/

#define CM_ISS_CLKSTCTRL            (PRCM_BASE_ADDR + 0x0700)
#define CM_ISS_IVAHD_CLKCTRL         (PRCM_BASE_ADDR + 0x0720)
#define CM_ISS_SL2_CLKCTRL           (PRCM_BASE_ADDR + 0x0724)
#define PM_ISS_PWRSTST               (PRCM_BASE_ADDR + 0x0D04)
#define RM_ISS_RSTCTRL            (PRCM_BASE_ADDR + 0x0D10)
#define RM_ISS_RSTST                (PRCM_BASE_ADDR + 0x0D14)

/*END OF ISS PRCM Definition*/

/*EMIF4 PRCM Defintion*/
#define CM_DEFAULT_L3_FAST_CLKSTCTRL    (PRCM_BASE_ADDR + 0x0508)
#define CM_DEFAULT_EMIF_0_CLKCTRL        (PRCM_BASE_ADDR + 0x0520)
#define CM_DEFAULT_DMM_CLKCTRL             (PRCM_BASE_ADDR + 0x0528)
#define CM_DEFAULT_FW_CLKCTRL             (PRCM_BASE_ADDR + 0x052C)

/*end of EMIF4 PRCM definition*/

/* McASP PRCM definitions */
#define CM_ALWON_MCA_0_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1540)
#define CM_ALWON_MCA_1_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1544)

#define CM_ALWON_I2C_0_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1564)
#define CM_ALWON_I2C_1_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1568)

#define CM_ALWON_SPI_0_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1590)
#define CM_ALWON_MMC_HS_0_CLKSTCTRL        (PRCM_BASE_ADDR + 0x161C)
#define CM_ALWON_MMC_HS_1_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1620)
#define MC_ALWON_ETHNET_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1404)
#define MC_ALWON_ETH_0_CLKSTCTRL        (PRCM_BASE_ADDR + 0x15D4)
#define MC_ALWON_ETH_1_CLKSTCTRL        (PRCM_BASE_ADDR + 0x15D8)
#define CM_ALWON_DCAN_0_CLKCTRL         (PRCM_BASE_ADDR + 0x1618)

/* Keypad GPIO PRCM definitions */
#define CM_ALWON_GPIO_0_CLKCTRL            (PRCM_BASE_ADDR + 0x155C)
#define CM_ALWON_GPIO_1_CLKCTRL            (PRCM_BASE_ADDR + 0x1560)
#define CM_ALWON_GPIO_2_CLKCTRL            (PRCM_BASE_ADDR + 0x1564)

#define CM_ALWON2_USB_CLKCTRL            (PRCM_BASE_ADDR + 0x0558)
#define RM_ALWON2_RSTCTRL                (PRCM_BASE_ADDR + 0x0B10)
#define RM_ALWON2_RSTST                 (PRCM_BASE_ADDR + 0x0B14)
#define CM_ALWON2_L3_SLOW_CLKSTCTRL        (PRCM_BASE_ADDR + 0x0514)


/* **********************DDR *************************/
#define DMM_LISA_MAP__0                    (DMM_BASE_ADDR + 0x40)
#define DMM_LISA_MAP__1                    (DMM_BASE_ADDR + 0x44)
#define DMM_LISA_MAP__2                    (DMM_BASE_ADDR + 0x48)
#define DMM_LISA_MAP__3                    (DMM_BASE_ADDR + 0x4C)
#define DMM_PAT_BASE_ADDR                 (DMM_BASE_ADDR + 0x460)

/*Duplicate entry*/
#define EMIF4_0_SDRAM_CONFIG            (EMIF4_0_CFG_BASE_ADDR + 0x08)
#define EMIF4_0_SDRAM_CONFIG2            (EMIF4_0_CFG_BASE_ADDR + 0x0C)
#define EMIF4_0_SDRAM_REF_CTRL            (EMIF4_0_CFG_BASE_ADDR + 0x10)
#define EMIF4_0_SDRAM_REF_CTRL_SHADOW    (EMIF4_0_CFG_BASE_ADDR + 0x14)
#define EMIF4_0_SDRAM_TIM_1                (EMIF4_0_CFG_BASE_ADDR + 0x18)
#define EMIF4_0_SDRAM_TIM_1_SHADOW        (EMIF4_0_CFG_BASE_ADDR + 0x1C)
#define EMIF4_0_SDRAM_TIM_2                (EMIF4_0_CFG_BASE_ADDR + 0x20)
#define EMIF4_0_SDRAM_TIM_2_SHADOW        (EMIF4_0_CFG_BASE_ADDR + 0x24)
#define EMIF4_0_SDRAM_TIM_3                (EMIF4_0_CFG_BASE_ADDR + 0x28)
#define EMIF4_0_SDRAM_TIM_3_SHADOW        (EMIF4_0_CFG_BASE_ADDR + 0x2C)
#define EMIF4_0_DDR_PHY_CTRL_1            (EMIF4_0_CFG_BASE_ADDR + 0xE4)
#define EMIF4_0_DDR_PHY_CTRL_1_SHADOW    (EMIF4_0_CFG_BASE_ADDR + 0xE8)
/*end*/
#define EMIF4_0_IODFT_TLGC                (EMIF4_0_CFG_BASE_ADDR + 0x60)


#define       DDR0_PHY_BASE_ADDR    0x47C0C400

#define       DDR0_IO_CTRL           0x48140E04
#define       VTP0_CTRL_REG       0x48140E0C
#define       DMM_BASE_ADDR            0x4E000000

#define       CMD0_REG_PHY0_CTRL_SLAVE_RATIO_0    (0x01C + DDR0_PHY_BASE_ADDR)
#define       CMD0_REG_PHY0_DLL_LOCK_DIFF_0     (0x028 + DDR0_PHY_BASE_ADDR)
#define       CMD0_REG_PHY0_INVERT_CLKOUT_0     (0x02C + DDR0_PHY_BASE_ADDR)
#define       CMD1_REG_PHY0_CTRL_SLAVE_RATIO_0 (0x050 + DDR0_PHY_BASE_ADDR)
#define       CMD1_REG_PHY0_DLL_LOCK_DIFF_0    (0x05C + DDR0_PHY_BASE_ADDR)
#define       CMD1_REG_PHY0_INVERT_CLKOUT_0    (0x060 + DDR0_PHY_BASE_ADDR)
#define       CMD2_REG_PHY0_CTRL_SLAVE_RATIO_0    (0x084 + DDR0_PHY_BASE_ADDR)
#define       CMD2_REG_PHY0_DLL_LOCK_DIFF_0    (0x090 + DDR0_PHY_BASE_ADDR)
#define       CMD2_REG_PHY0_INVERT_CLKOUT_0    (0x094 + DDR0_PHY_BASE_ADDR)


#define       PHY_WR_DQS       0x1E
#define       PHY_WR_DATA      0x8E
#define       PHY_FIFO_WE      0x8E
#define       PHY_RD_DQS       0x8E // I kept same as PHY_WR_DQS --- Ankit

#define       PHY_INVERT_CLKOUT      0
#define       CMD_SLAVE_RATIO        0x80
#define       DLL_LOCK_DIFF      0x4
#define       PHY_REG_DQ_OFFSET      0x40
/*********************DDR 3 Parameters ************************/

#define CM_ALWON_L3_SLOW_CLKSTCTRL        (PRCM_BASE_ADDR + 0x1400)

#define CM_ALWON_TIMER_0_CLKCTRL         (PRCM_BASE_ADDR + 0x156C)
#define CM_ALWON_TIMER_1_CLKCTRL         (PRCM_BASE_ADDR + 0x1570)
#define CM_ALWON_TIMER_2_CLKCTRL         (PRCM_BASE_ADDR + 0x1574)
#define CM_ALWON_TIMER_3_CLKCTRL         (PRCM_BASE_ADDR + 0x1578)
#define CM_ALWON_TIMER_4_CLKCTRL         (PRCM_BASE_ADDR + 0x157C)
#define CM_ALWON_TIMER_5_CLKCTRL         (PRCM_BASE_ADDR + 0x1580)
#define CM_ALWON_TIMER_6_CLKCTRL         (PRCM_BASE_ADDR + 0x1584)
#define CM_ALWON_TIMER_7_CLKCTRL         (PRCM_BASE_ADDR + 0x1588)
#define CM_ALWON_SYSCLK5_CLKSTCTRL    (PRCM_BASE_ADDR + 0x1424)
#define CM_ALWON_DCAN_0_1_CLKCTRL    (PRCM_BASE_ADDR + 0x1618)

#define CM_TIMER0_CLKSEL                (PRCM_BASE_ADDR + 0x038C)
#define CM_TIMER1_CLKSEL                (PRCM_BASE_ADDR + 0x0390)
#define CM_TIMER2_CLKSEL                (PRCM_BASE_ADDR + 0x0394)
#define CM_TIMER3_CLKSEL                (PRCM_BASE_ADDR + 0x0398)
#define CM_TIMER4_CLKSEL                (PRCM_BASE_ADDR + 0x039C)
#define CM_TIMER5_CLKSEL                (PRCM_BASE_ADDR + 0x03A0)
#define CM_TIMER6_CLKSEL                (PRCM_BASE_ADDR + 0x03A4)
#define CM_TIMER7_CLKSEL                (PRCM_BASE_ADDR + 0x03A8)

#define CM_HDVPSS_CLKSTCTRL                (PRCM_BASE_ADDR + 0x0800)
#define CM_HDVPSS_HDVPSS_CLKCTRL        (PRCM_BASE_ADDR + 0x0820)
#define CM_HDVPSS_HDMI_CLKCTRL            (PRCM_BASE_ADDR + 0x0824)

#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
#define RD_MEM_32(addr)            *(unsigned int*)(addr)
#define RD_M_WR_MEM_32(addr,data,mask) WR_MEM_32(addr, (RD_MEM_32(addr)& mask)| data)
#define UWORD32                  unsigned int

#define SIZE 1
#define DATA_SIZE 10
#define OCMC0RAM_BASE_ADDR                 0x40300000

#define DELAY_TIME  5
#define DMTIMER0_BASE_ADDR                 0x4802C000
#define DMTIMER1_BASE_ADDR                 0x4802E000
#define DMTIMER2_BASE_ADDR                 0x48040000
#define DMTIMER3_BASE_ADDR                 0x48042000
#define DMTIMER4_BASE_ADDR                 0x48044000
#define DMTIMER5_BASE_ADDR                 0x48046000
#define DMTIMER6_BASE_ADDR                 0x48048000
#define DMTIMER7_BASE_ADDR                 0x4804A000

#define OB_SIZE                         0x1
#define PCIE_REGISTER_BASE              0x51000000
#define PCIE_TARGET                     0x20000000

#define EP_APPL_OB_SIZE                 0x30
#define EP_APPL_OB_OFFSET_INDEX(n)      0x200 + 8 * n
#define EP_APPL_OB_OFFSET_HI(n)         0x204 + 8 * n
#define EP_TYP0_STAT_CMD                0x1004
#define EP_TYP0_BAR0                    0x1010
#define EP_TYP0_BAR1                    0x1014
#define EP_APPL_CMD_STATUS              0x4
#define EP_PL_DEBUG0                    0x1728

#define RC_APPL_OB_SIZE             0x30
#define RC_APPL_OB_OFFSET_INDEX(n)  0x200 + 8 * n
#define RC_APPL_OB_OFFSET_HI(n)     0x204 + 8 * n
#define RC_TYP1_STAT_CMD            0x1004
#define RC_APPL_CMD_STATUS          0x4
#define RC_PL_DEBUG0                0x1728
#define RM_RC_TYP0_BAR0             0x10 + 0x2000
#define RM_RC_TYP0_BAR1             0x14 + 0x2000

/********   SD DAC REGISTERS   **************/
#define SD_DAC_CTRL             (CONTROL_BASE_ADDRESS+0x670)
#define SD_DAC0_CAL             (CONTROL_BASE_ADDRESS+0x674)
#define SD_DAC0_REGCTRL         (CONTROL_BASE_ADDRESS+0x67C)
#define SD_DAC0_REGSTATUS       (CONTROL_BASE_ADDRESS+0x680)

/********   HD DAC REGISTERS   **************/
#define HD_DAC_CTL                 (CONTROL_BASE_ADDRESS+0x1200)

#define HD_DAC_ACAL             (CONTROL_BASE_ADDRESS+0x1204)
#define HD_DAC_BCAL             (CONTROL_BASE_ADDRESS+0x1208)
#define HD_DAC_CCAL             (CONTROL_BASE_ADDRESS+0x120C)

#define HD_DACA_REGCTRL         (CONTROL_BASE_ADDRESS+0x1210)
#define HD_DACA_REGSTATUS       (CONTROL_BASE_ADDRESS+0x1214)
#define HD_DACB_REGCTRL         (CONTROL_BASE_ADDRESS+0x1218)
#define HD_DACB_REGSTATUS       (CONTROL_BASE_ADDRESS+0x121C)
#define HD_DACC_REGCTRL         (CONTROL_BASE_ADDRESS+0x1220)
#define HD_DACC_REGSTATUS       (CONTROL_BASE_ADDRESS+0x1224)


    /* PIN Control defines */
/* DM385 does not have the below pins
    PINCNTL27,28,29,30,37,38,39,40,43,44,45,46,47,48,49,50,51,
    52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67 */

#define    PINCNTL1    (    CTRL_MODULE_BASE_ADDR +    0x0800    )
#define    PINCNTL2    (    CTRL_MODULE_BASE_ADDR +    0x0804    )
#define    PINCNTL3    (    CTRL_MODULE_BASE_ADDR +    0x0808    )
#define    PINCNTL4    (    CTRL_MODULE_BASE_ADDR +    0x080C    )
#define    PINCNTL5    (    CTRL_MODULE_BASE_ADDR +    0x0810    )
#define    PINCNTL6    (    CTRL_MODULE_BASE_ADDR +    0x0814    )
#define    PINCNTL7    (    CTRL_MODULE_BASE_ADDR +    0x0818    )
#define    PINCNTL8    (    CTRL_MODULE_BASE_ADDR +    0x081C    )
#define    PINCNTL9    (    CTRL_MODULE_BASE_ADDR +    0x0820    )
#define    PINCNTL10    (    CTRL_MODULE_BASE_ADDR +    0x0824    )
#define    PINCNTL11    (    CTRL_MODULE_BASE_ADDR +    0x0828    )
#define    PINCNTL12    (    CTRL_MODULE_BASE_ADDR +    0x082C    )
#define    PINCNTL13    (    CTRL_MODULE_BASE_ADDR +    0x0830    )
#define    PINCNTL14    (    CTRL_MODULE_BASE_ADDR +    0x0834    )
#define    PINCNTL15    (    CTRL_MODULE_BASE_ADDR +    0x0838    )
#define    PINCNTL16    (    CTRL_MODULE_BASE_ADDR +    0x083C    )
#define    PINCNTL17    (    CTRL_MODULE_BASE_ADDR +    0x0840    )
#define    PINCNTL18    (    CTRL_MODULE_BASE_ADDR +    0x0844    )
#define    PINCNTL19    (    CTRL_MODULE_BASE_ADDR +    0x0848    )
#define    PINCNTL20    (    CTRL_MODULE_BASE_ADDR +    0x084C    )
#define    PINCNTL21    (    CTRL_MODULE_BASE_ADDR +    0x0850    )
#define    PINCNTL22    (    CTRL_MODULE_BASE_ADDR +    0x0854    )
#define    PINCNTL23    (    CTRL_MODULE_BASE_ADDR +    0x0858    )
#define    PINCNTL24    (    CTRL_MODULE_BASE_ADDR +    0x085C    )
#define    PINCNTL25    (    CTRL_MODULE_BASE_ADDR +    0x0860    )
#define    PINCNTL26    (    CTRL_MODULE_BASE_ADDR +    0x0864    )
//============Not present in DM385 start========================

#define    PINCNTL27    (    CTRL_MODULE_BASE_ADDR +    0x0868    )
#define    PINCNTL28    (    CTRL_MODULE_BASE_ADDR +    0x086C    )
#define    PINCNTL29    (    CTRL_MODULE_BASE_ADDR +    0x0870    )
#define    PINCNTL30    (    CTRL_MODULE_BASE_ADDR +    0x0874    )
//============Not present in DM385 end==========================

#define    PINCNTL31    (    CTRL_MODULE_BASE_ADDR +    0x0878    )
#define    PINCNTL32    (    CTRL_MODULE_BASE_ADDR +    0x087C    )
#define    PINCNTL33    (    CTRL_MODULE_BASE_ADDR +    0x0880    )
#define    PINCNTL34    (    CTRL_MODULE_BASE_ADDR +    0x0884    )
#define    PINCNTL35    (    CTRL_MODULE_BASE_ADDR +    0x0888    )
#define    PINCNTL36    (    CTRL_MODULE_BASE_ADDR +    0x088C    )

//============Not present in DM385 start========================
#define    PINCNTL37    (    CTRL_MODULE_BASE_ADDR +    0x0890    )
#define    PINCNTL38    (    CTRL_MODULE_BASE_ADDR +    0x0894    )
#define    PINCNTL39    (    CTRL_MODULE_BASE_ADDR +    0x0898    )
#define    PINCNTL40    (    CTRL_MODULE_BASE_ADDR +    0x089C    )
//============Not present in DM385 end==========================

#define    PINCNTL41    (    CTRL_MODULE_BASE_ADDR +    0x08A0    )
#define    PINCNTL42    (    CTRL_MODULE_BASE_ADDR +    0x08A4    )
//============Not present in DM385 start========================
#define    PINCNTL43    (    CTRL_MODULE_BASE_ADDR +    0x08A8    )
#define    PINCNTL44    (    CTRL_MODULE_BASE_ADDR +    0x08AC    )
#define    PINCNTL45    (    CTRL_MODULE_BASE_ADDR +    0x08B0    )
#define    PINCNTL46    (    CTRL_MODULE_BASE_ADDR +    0x08B4    )
#define    PINCNTL47    (    CTRL_MODULE_BASE_ADDR +    0x08B8    )
#define    PINCNTL48    (    CTRL_MODULE_BASE_ADDR +    0x08BC    )
#define    PINCNTL49    (    CTRL_MODULE_BASE_ADDR +    0x08C0    )
#define    PINCNTL50    (    CTRL_MODULE_BASE_ADDR +    0x08C4    )
#define    PINCNTL51    (    CTRL_MODULE_BASE_ADDR +    0x08C8    )
#define    PINCNTL52    (    CTRL_MODULE_BASE_ADDR +    0x08CC    )
#define    PINCNTL53    (    CTRL_MODULE_BASE_ADDR +    0x08D0    )
#define    PINCNTL54    (    CTRL_MODULE_BASE_ADDR +    0x08D4    )
#define    PINCNTL55    (    CTRL_MODULE_BASE_ADDR +    0x08D8    )
#define    PINCNTL56    (    CTRL_MODULE_BASE_ADDR +    0x08DC    )
#define    PINCNTL57    (    CTRL_MODULE_BASE_ADDR +    0x08E0    )
#define    PINCNTL58    (    CTRL_MODULE_BASE_ADDR +    0x08E4    )
#define    PINCNTL59    (    CTRL_MODULE_BASE_ADDR +    0x08E8    )
#define    PINCNTL60    (    CTRL_MODULE_BASE_ADDR +    0x08EC    )
#define    PINCNTL61    (    CTRL_MODULE_BASE_ADDR +    0x08F0    )
#define    PINCNTL62    (    CTRL_MODULE_BASE_ADDR +    0x08F4    )
#define    PINCNTL63    (    CTRL_MODULE_BASE_ADDR +    0x08F8    )
#define    PINCNTL64    (    CTRL_MODULE_BASE_ADDR +    0x08FC    )
#define    PINCNTL65    (    CTRL_MODULE_BASE_ADDR +    0x0900    )
#define    PINCNTL66    (    CTRL_MODULE_BASE_ADDR +    0x0904    )
#define    PINCNTL67    (    CTRL_MODULE_BASE_ADDR +    0x0908    )
//============Not present in DM385 end=========================
#define    PINCNTL68    (    CTRL_MODULE_BASE_ADDR +    0x090C    )
#define    PINCNTL69    (    CTRL_MODULE_BASE_ADDR +    0x0910    )
#define    PINCNTL70    (    CTRL_MODULE_BASE_ADDR +    0x0914    )
#define    PINCNTL71    (    CTRL_MODULE_BASE_ADDR +    0x0918    )
#define    PINCNTL72    (    CTRL_MODULE_BASE_ADDR +    0x091C    )
#define    PINCNTL73    (    CTRL_MODULE_BASE_ADDR +    0x0920    )
#define    PINCNTL74    (    CTRL_MODULE_BASE_ADDR +    0x0924    )
#define    PINCNTL75    (    CTRL_MODULE_BASE_ADDR +    0x0928    )
#define    PINCNTL76    (    CTRL_MODULE_BASE_ADDR +    0x092C    )
#define    PINCNTL77    (    CTRL_MODULE_BASE_ADDR +    0x0930    )
#define    PINCNTL78    (    CTRL_MODULE_BASE_ADDR +    0x0934    )
#define    PINCNTL79    (    CTRL_MODULE_BASE_ADDR +    0x0938    )
#define    PINCNTL80    (    CTRL_MODULE_BASE_ADDR +    0x093C    )
#define    PINCNTL81    (    CTRL_MODULE_BASE_ADDR +    0x0940    )
#define    PINCNTL82    (    CTRL_MODULE_BASE_ADDR +    0x0944    )
#define    PINCNTL83    (    CTRL_MODULE_BASE_ADDR +    0x0948    )
#define    PINCNTL84    (    CTRL_MODULE_BASE_ADDR +    0x094C    )
#define    PINCNTL85    (    CTRL_MODULE_BASE_ADDR +    0x0950    )
#define    PINCNTL86    (    CTRL_MODULE_BASE_ADDR +    0x0954    )
#define    PINCNTL87    (    CTRL_MODULE_BASE_ADDR +    0x0958    )
#define    PINCNTL88    (    CTRL_MODULE_BASE_ADDR +    0x095C    )
#define    PINCNTL89    (    CTRL_MODULE_BASE_ADDR +    0x0960    )
#define    PINCNTL90    (    CTRL_MODULE_BASE_ADDR +    0x0964    )
#define    PINCNTL91    (    CTRL_MODULE_BASE_ADDR +    0x0968    )
#define    PINCNTL92    (    CTRL_MODULE_BASE_ADDR +    0x096C    )
#define    PINCNTL93    (    CTRL_MODULE_BASE_ADDR +    0x0970    )
#define    PINCNTL94    (    CTRL_MODULE_BASE_ADDR +    0x0974    )
#define    PINCNTL95    (    CTRL_MODULE_BASE_ADDR +    0x0978    )
#define    PINCNTL96    (    CTRL_MODULE_BASE_ADDR +    0x097C    )
#define    PINCNTL97    (    CTRL_MODULE_BASE_ADDR +    0x0980    )
#define    PINCNTL98    (    CTRL_MODULE_BASE_ADDR +    0x0984    )
#define    PINCNTL99    (    CTRL_MODULE_BASE_ADDR +    0x0988    )
#define    PINCNTL100    (    CTRL_MODULE_BASE_ADDR +    0x098C    )
#define    PINCNTL101    (    CTRL_MODULE_BASE_ADDR +    0x0990    )
#define    PINCNTL102    (    CTRL_MODULE_BASE_ADDR +    0x0994    )
#define    PINCNTL103    (    CTRL_MODULE_BASE_ADDR +    0x0998    )
#define    PINCNTL104    (    CTRL_MODULE_BASE_ADDR +    0x099C    )
#define    PINCNTL105    (    CTRL_MODULE_BASE_ADDR +    0x09A0    )
#define    PINCNTL106    (    CTRL_MODULE_BASE_ADDR +    0x09A4    )
#define    PINCNTL107    (    CTRL_MODULE_BASE_ADDR +    0x09A8    )
#define    PINCNTL108    (    CTRL_MODULE_BASE_ADDR +    0x09AC    )
#define    PINCNTL109    (    CTRL_MODULE_BASE_ADDR +    0x09B0    )
#define    PINCNTL110    (    CTRL_MODULE_BASE_ADDR +    0x09B4    )
#define    PINCNTL111    (    CTRL_MODULE_BASE_ADDR +    0x09B8    )
#define    PINCNTL112    (    CTRL_MODULE_BASE_ADDR +    0x09BC    )
#define    PINCNTL113    (    CTRL_MODULE_BASE_ADDR +    0x09C0    )
#define    PINCNTL114    (    CTRL_MODULE_BASE_ADDR +    0x09C4    )
#define    PINCNTL115    (    CTRL_MODULE_BASE_ADDR +    0x09C8    )
#define    PINCNTL116    (    CTRL_MODULE_BASE_ADDR +    0x09CC    )
#define    PINCNTL117    (    CTRL_MODULE_BASE_ADDR +    0x09D0    )
#define    PINCNTL118    (    CTRL_MODULE_BASE_ADDR +    0x09D4    )
#define    PINCNTL119    (    CTRL_MODULE_BASE_ADDR +    0x09D8    )
#define    PINCNTL120    (    CTRL_MODULE_BASE_ADDR +    0x09DC    )
#define    PINCNTL121    (    CTRL_MODULE_BASE_ADDR +    0x09E0    )
#define    PINCNTL122    (    CTRL_MODULE_BASE_ADDR +    0x09E4    )
#define    PINCNTL123    (    CTRL_MODULE_BASE_ADDR +    0x09E8    )
#define    PINCNTL124    (    CTRL_MODULE_BASE_ADDR +    0x09EC    )
#define    PINCNTL125    (    CTRL_MODULE_BASE_ADDR +    0x09F0    )
#define    PINCNTL126    (    CTRL_MODULE_BASE_ADDR +    0x09F4    )
#define    PINCNTL127    (    CTRL_MODULE_BASE_ADDR +    0x09F8    )
#define    PINCNTL128    (    CTRL_MODULE_BASE_ADDR +    0x09FC    )
#define    PINCNTL129    (    CTRL_MODULE_BASE_ADDR +    0x0A00    )
#define    PINCNTL130    (    CTRL_MODULE_BASE_ADDR +    0x0A04    )
#define    PINCNTL131    (    CTRL_MODULE_BASE_ADDR +    0x0A08    )
#define    PINCNTL132    (    CTRL_MODULE_BASE_ADDR +    0x0A0C    )
#define    PINCNTL133    (    CTRL_MODULE_BASE_ADDR +    0x0A10    )
#define    PINCNTL134    (    CTRL_MODULE_BASE_ADDR +    0x0A14    )
#define    PINCNTL135    (    CTRL_MODULE_BASE_ADDR +    0x0A18    )
#define    PINCNTL136    (    CTRL_MODULE_BASE_ADDR +    0x0A1C    )
#define    PINCNTL137    (    CTRL_MODULE_BASE_ADDR +    0x0A20    )
#define    PINCNTL138    (    CTRL_MODULE_BASE_ADDR +    0x0A24    )
#define    PINCNTL139    (    CTRL_MODULE_BASE_ADDR +    0x0A28    )
#define    PINCNTL140    (    CTRL_MODULE_BASE_ADDR +    0x0A2C    )
#define    PINCNTL141    (    CTRL_MODULE_BASE_ADDR +    0x0A30    )
#define    PINCNTL142    (    CTRL_MODULE_BASE_ADDR +    0x0A34    )
#define    PINCNTL143    (    CTRL_MODULE_BASE_ADDR +    0x0A38    )
#define    PINCNTL144    (    CTRL_MODULE_BASE_ADDR +    0x0A3C    )
#define    PINCNTL145    (    CTRL_MODULE_BASE_ADDR +    0x0A40    )
#define    PINCNTL146    (    CTRL_MODULE_BASE_ADDR +    0x0A44    )
#define    PINCNTL147    (    CTRL_MODULE_BASE_ADDR +    0x0A48    )
#define    PINCNTL148    (    CTRL_MODULE_BASE_ADDR +    0x0A4C    )
#define    PINCNTL149    (    CTRL_MODULE_BASE_ADDR +    0x0A50    )
#define    PINCNTL150    (    CTRL_MODULE_BASE_ADDR +    0x0A54    )
#define    PINCNTL151    (    CTRL_MODULE_BASE_ADDR +    0x0A58    )
#define    PINCNTL152    (    CTRL_MODULE_BASE_ADDR +    0x0A5C    )
#define    PINCNTL153    (    CTRL_MODULE_BASE_ADDR +    0x0A60    )
#define    PINCNTL154    (    CTRL_MODULE_BASE_ADDR +    0x0A64    )
#define    PINCNTL155    (    CTRL_MODULE_BASE_ADDR +    0x0A68    )
#define    PINCNTL156    (    CTRL_MODULE_BASE_ADDR +    0x0A6C    )
#define    PINCNTL157    (    CTRL_MODULE_BASE_ADDR +    0x0A70    )
#define    PINCNTL158    (    CTRL_MODULE_BASE_ADDR +    0x0A74    )
#define    PINCNTL159    (    CTRL_MODULE_BASE_ADDR +    0x0A78    )
#define    PINCNTL160    (    CTRL_MODULE_BASE_ADDR +    0x0A7C    )
#define    PINCNTL161    (    CTRL_MODULE_BASE_ADDR +    0x0A80    )
#define    PINCNTL162    (    CTRL_MODULE_BASE_ADDR +    0x0A84    )
#define    PINCNTL163    (    CTRL_MODULE_BASE_ADDR +    0x0A88    )
#define    PINCNTL164    (    CTRL_MODULE_BASE_ADDR +    0x0A8C    )
#define    PINCNTL165    (    CTRL_MODULE_BASE_ADDR +    0x0A90    )
#define    PINCNTL166    (    CTRL_MODULE_BASE_ADDR +    0x0A94    )
#define    PINCNTL167    (    CTRL_MODULE_BASE_ADDR +    0x0A98    )
#define    PINCNTL168    (    CTRL_MODULE_BASE_ADDR +    0x0A9C    )
#define    PINCNTL169    (    CTRL_MODULE_BASE_ADDR +    0x0AA0    )
#define    PINCNTL170    (    CTRL_MODULE_BASE_ADDR +    0x0AA4    )
#define    PINCNTL171    (    CTRL_MODULE_BASE_ADDR +    0x0AA8    )
#define    PINCNTL172    (    CTRL_MODULE_BASE_ADDR +    0x0AAC    )
#define    PINCNTL173    (    CTRL_MODULE_BASE_ADDR +    0x0AB0    )
#define    PINCNTL174    (    CTRL_MODULE_BASE_ADDR +    0x0AB4    )
#define    PINCNTL175    (    CTRL_MODULE_BASE_ADDR +    0x0AB8    )
#define    PINCNTL176    (    CTRL_MODULE_BASE_ADDR +    0x0ABC    )
#define    PINCNTL177    (    CTRL_MODULE_BASE_ADDR +    0x0AC0    )
#define    PINCNTL178    (    CTRL_MODULE_BASE_ADDR +    0x0AC4    )
#define    PINCNTL179    (    CTRL_MODULE_BASE_ADDR +    0x0AC8    )
#define    PINCNTL180    (    CTRL_MODULE_BASE_ADDR +    0x0ACC    )
#define    PINCNTL181    (    CTRL_MODULE_BASE_ADDR +    0x0AD0    )
#define    PINCNTL182    (    CTRL_MODULE_BASE_ADDR +    0x0AD4    )
#define    PINCNTL183    (    CTRL_MODULE_BASE_ADDR +    0x0AD8    )
#define    PINCNTL184    (    CTRL_MODULE_BASE_ADDR +    0x0ADC    )
#define    PINCNTL185    (    CTRL_MODULE_BASE_ADDR +    0x0AE0    )
#define    PINCNTL186    (    CTRL_MODULE_BASE_ADDR +    0x0AE4    )
#define    PINCNTL187    (    CTRL_MODULE_BASE_ADDR +    0x0AE8    )
#define    PINCNTL188    (    CTRL_MODULE_BASE_ADDR +    0x0AEC    )
#define    PINCNTL189    (    CTRL_MODULE_BASE_ADDR +    0x0AF0    )
#define    PINCNTL190    (    CTRL_MODULE_BASE_ADDR +    0x0AF4    )
#define    PINCNTL191    (    CTRL_MODULE_BASE_ADDR +    0x0AF8    )
#define    PINCNTL192    (    CTRL_MODULE_BASE_ADDR +    0x0AFC    )
#define    PINCNTL193    (    CTRL_MODULE_BASE_ADDR +    0x0B00    )
#define    PINCNTL194    (    CTRL_MODULE_BASE_ADDR +    0x0B04    )
#define    PINCNTL195    (    CTRL_MODULE_BASE_ADDR +    0x0B08    )
#define    PINCNTL196    (    CTRL_MODULE_BASE_ADDR +    0x0B0C    )
#define    PINCNTL197    (    CTRL_MODULE_BASE_ADDR +    0x0B10    )
#define    PINCNTL198    (    CTRL_MODULE_BASE_ADDR +    0x0B14    )
#define    PINCNTL199    (    CTRL_MODULE_BASE_ADDR +    0x0B18    )
#define    PINCNTL200    (    CTRL_MODULE_BASE_ADDR +    0x0B1C    )
#define    PINCNTL201    (    CTRL_MODULE_BASE_ADDR +    0x0B20    )
#define    PINCNTL202    (    CTRL_MODULE_BASE_ADDR +    0x0B24    )
#define    PINCNTL203    (    CTRL_MODULE_BASE_ADDR +    0x0B28    )
#define    PINCNTL204    (    CTRL_MODULE_BASE_ADDR +    0x0B2C    )
#define    PINCNTL205    (    CTRL_MODULE_BASE_ADDR +    0x0B30    )
#define    PINCNTL206    (    CTRL_MODULE_BASE_ADDR +    0x0B34    )
#define    PINCNTL207    (    CTRL_MODULE_BASE_ADDR +    0x0B38    )
#define    PINCNTL208    (    CTRL_MODULE_BASE_ADDR +    0x0B3C    )
#define    PINCNTL209    (    CTRL_MODULE_BASE_ADDR +    0x0B40    )
#define    PINCNTL210    (    CTRL_MODULE_BASE_ADDR +    0x0B44    )
#define    PINCNTL211    (    CTRL_MODULE_BASE_ADDR +    0x0B48    )
#define    PINCNTL212    (    CTRL_MODULE_BASE_ADDR +    0x0B4C    )
#define    PINCNTL213    (    CTRL_MODULE_BASE_ADDR +    0x0B50    )
#define    PINCNTL214    (    CTRL_MODULE_BASE_ADDR +    0x0B54    )
#define    PINCNTL215    (    CTRL_MODULE_BASE_ADDR +    0x0B58    )
#define    PINCNTL216    (    CTRL_MODULE_BASE_ADDR +    0x0B5C    )
#define    PINCNTL217    (    CTRL_MODULE_BASE_ADDR +    0x0B60    )
#define    PINCNTL218    (    CTRL_MODULE_BASE_ADDR +    0x0B64    )
#define    PINCNTL219    (    CTRL_MODULE_BASE_ADDR +    0x0B68    )
#define    PINCNTL220    (    CTRL_MODULE_BASE_ADDR +    0x0B6C    )
#define    PINCNTL221    (    CTRL_MODULE_BASE_ADDR +    0x0B70    )
#define    PINCNTL222    (    CTRL_MODULE_BASE_ADDR +    0x0B74    )
#define    PINCNTL223    (    CTRL_MODULE_BASE_ADDR +    0x0B78    )
#define    PINCNTL224    (    CTRL_MODULE_BASE_ADDR +    0x0B7C    )
#define    PINCNTL225    (    CTRL_MODULE_BASE_ADDR +    0x0B80    )
#define    PINCNTL226    (    CTRL_MODULE_BASE_ADDR +    0x0B84    )
#define    PINCNTL227    (    CTRL_MODULE_BASE_ADDR +    0x0B88    )
#define    PINCNTL228    (    CTRL_MODULE_BASE_ADDR +    0x0B8C    )
#define    PINCNTL229    (    CTRL_MODULE_BASE_ADDR +    0x0B90    )
#define    PINCNTL230    (    CTRL_MODULE_BASE_ADDR +    0x0B94    )
#define    PINCNTL231    (    CTRL_MODULE_BASE_ADDR +    0x0B98    )
#define    PINCNTL232    (    CTRL_MODULE_BASE_ADDR +    0x0B9C    )
#define    PINCNTL233    (    CTRL_MODULE_BASE_ADDR +    0x0BA0    )
#define    PINCNTL234    (    CTRL_MODULE_BASE_ADDR +    0x0BA4    )
#define    PINCNTL235    (    CTRL_MODULE_BASE_ADDR +    0x0BA8    )
#define    PINCNTL236    (    CTRL_MODULE_BASE_ADDR +    0x0BAC    )
#define    PINCNTL237    (    CTRL_MODULE_BASE_ADDR +    0x0BB0    )
#define    PINCNTL238    (    CTRL_MODULE_BASE_ADDR +    0x0BB4    )
#define    PINCNTL239    (    CTRL_MODULE_BASE_ADDR +    0x0BB8    )
#define    PINCNTL240    (    CTRL_MODULE_BASE_ADDR +    0x0BBC    )
#define    PINCNTL241    (    CTRL_MODULE_BASE_ADDR +    0x0BC0    )
#define    PINCNTL242    (    CTRL_MODULE_BASE_ADDR +    0x0BC4    )
#define    PINCNTL243    (    CTRL_MODULE_BASE_ADDR +    0x0BC8    )
#define    PINCNTL244    (    CTRL_MODULE_BASE_ADDR +    0x0BCC    )
#define    PINCNTL245    (    CTRL_MODULE_BASE_ADDR +    0x0BD0    )
#define    PINCNTL246    (    CTRL_MODULE_BASE_ADDR +    0x0BD4    )
#define    PINCNTL247    (    CTRL_MODULE_BASE_ADDR +    0x0BD8    )
#define    PINCNTL248    (    CTRL_MODULE_BASE_ADDR +    0x0BDC    )
#define    PINCNTL249    (    CTRL_MODULE_BASE_ADDR +    0x0BE0    )
#define    PINCNTL250    (    CTRL_MODULE_BASE_ADDR +    0x0BE4    )
#define    PINCNTL251    (    CTRL_MODULE_BASE_ADDR +    0x0BE8    )
#define    PINCNTL252    (    CTRL_MODULE_BASE_ADDR +    0x0BEC    )
#define    PINCNTL253    (    CTRL_MODULE_BASE_ADDR +    0x0BF0    )
#define    PINCNTL254    (    CTRL_MODULE_BASE_ADDR +    0x0BF4    )
#define    PINCNTL255    (    CTRL_MODULE_BASE_ADDR +    0x0BF8    )
#define    PINCNTL256    (    CTRL_MODULE_BASE_ADDR +    0x0BFC    )
#define    PINCNTL257    (    CTRL_MODULE_BASE_ADDR +    0x0C00    )
#define    PINCNTL258    (    CTRL_MODULE_BASE_ADDR +    0x0C04    )
#define    PINCNTL259    (    CTRL_MODULE_BASE_ADDR +    0x0C08    )
#define    PINCNTL260    (    CTRL_MODULE_BASE_ADDR +    0x0C0C    )
#define    PINCNTL261    (    CTRL_MODULE_BASE_ADDR +    0x0C10    )
#define    PINCNTL262    (    CTRL_MODULE_BASE_ADDR +    0x0C14    )
#define    PINCNTL263    (    CTRL_MODULE_BASE_ADDR +    0x0C18    )
#define    PINCNTL264    (    CTRL_MODULE_BASE_ADDR +    0x0C1C    )
#define    PINCNTL265    (    CTRL_MODULE_BASE_ADDR +    0x0C20    )
#define    PINCNTL266    (    CTRL_MODULE_BASE_ADDR +    0x0C24    )
#define    PINCNTL267    (    CTRL_MODULE_BASE_ADDR +    0x0C28    )
#define    PINCNTL268    (    CTRL_MODULE_BASE_ADDR +    0x0C2C    )
#define    PINCNTL269    (    CTRL_MODULE_BASE_ADDR +    0x0C30    )
#define    PINCNTL270    (    CTRL_MODULE_BASE_ADDR +    0x0C34    )
#define    PINCNTL271    (    CTRL_MODULE_BASE_ADDR +    0x0C38    )


#define OSC_0                        20
#define OSC_1                        20
#define OSC_SRC_CTRL            (PLL_BASE_ADDRESS+0x02c0)
#define ARM_SRC_CLK             (PLL_BASE_ADDRESS+0x02c4)

// Top Level ADPLLJ

#define L3_PLL_BASE             (PLL_BASE_ADDRESS+0x110)
#define IVA_PLL_BASE            (PLL_BASE_ADDRESS+0x0E0)
#define DSS_PLL_BASE            (PLL_BASE_ADDRESS+0x170)
#define ISS_PLL_BASE            (PLL_BASE_ADDRESS+0x140)
#define USB_PLL_BASE            (PLL_BASE_ADDRESS+0x260)
#define AUDIO_PLL_BASE          (PLL_BASE_ADDRESS+0x230)
#define VIDEO_0_PLL_BASE        (PLL_BASE_ADDRESS+0x1A0)
#define VIDEO_1_PLL_BASE        (PLL_BASE_ADDRESS+0x1D0)
#define HDMI_PLL_BASE           (PLL_BASE_ADDRESS+0x200)
#define DDR_PLL_BASE            (PLL_BASE_ADDRESS+0x290)

//ADPLL intrnal Offset Registers
#define CLKCTRL                 0x4
#define TENABLE                 0x8
#define TENABLEDIV                 0xC
#define M2NDIV                  0x10
#define MN2DIV                     0x14
#define STATUS                     0x24

// ADPLLJ_CLKCRTL_Register Value Configurations
// ADPLLJ_CLKCRTL_Register SPEC bug  bit 19,bit29 -- CLKLDOEN,CLKDCOEN

#define ADPLLJ_CLKCRTL_HS2       0x00000801 //HS2 Mode,TINTZ =1  -- used by all PLL's except HDMI
#define ADPLLJ_CLKCRTL_HS1       0x00001001 //HS1 Mode,TINTZ =1  -- used only for HDMI
#define ADPLLJ_CLKCRTL_CLKDCO    0x200a0000 // Enable CLKDCOEN,CLKLDOEN,CLKDCOPWDNZ -- used for HDMI,USB

#define SATA0_BASE    0x4A140000
#define SATA1_BASE    0x4A0AE000

/********   SATA0 PLL REGISTERS   **************/
#define SATA0_PLLCFG0                             (CONTROL_BASE_ADDRESS+0x720)
#define SATA0_PLLCFG1                             (CONTROL_BASE_ADDRESS+0x724)
#define SATA0_PLLCFG2                             (CONTROL_BASE_ADDRESS+0x728)
#define SATA0_PLLCFG3                             (CONTROL_BASE_ADDRESS+0x72c)
#define SATA0_PLLCFG4                             (CONTROL_BASE_ADDRESS+0x730)
#define SATA0_PLLSTATUS                           (CONTROL_BASE_ADDRESS+0x734)
#define SATA0_RXSTATUS                            (CONTROL_BASE_ADDRESS+0x738)
#define SATA0_TXSTATUS                            (CONTROL_BASE_ADDRESS+0x73c)

/********   SATA1 PLL REGISTERS   **************/

#define SATA1_PLLCFG0                             (CONTROL_BASE_ADDRESS+0x74C)
#define SATA1_PLLCFG1                             (CONTROL_BASE_ADDRESS+0x750)
#define SATA1_PLLCFG2                             (CONTROL_BASE_ADDRESS+0x754)
#define SATA1_PLLCFG3                             (CONTROL_BASE_ADDRESS+0x758)
#define SATA1_PLLCFG4                             (CONTROL_BASE_ADDRESS+0x75C)
#define SATA1_PLLSTATUS                           (CONTROL_BASE_ADDRESS+0x760)
#define SATA1_RXSTATUS                            (CONTROL_BASE_ADDRESS+0x764)
#define SATA1_TXSTATUS                            (CONTROL_BASE_ADDRESS+0x768)

#define SATA_PHY_CFGRX0_OFFSET       (0x1104)
#define SATA_PHY_CFGRX1_OFFSET       (0x1108)
#define SATA_PHY_CFGRX2_OFFSET       (0x110C)
#define SATA_PHY_CFGRX3_OFFSET       (0x1110)

#define SATA_PHY_CFGTX0_OFFSET       (0x111C)
#define SATA_PHY_CFGTX1_OFFSET       (0x1120)
#define SATA_PHY_CFGTX2_OFFSET       (0x1124)
#define SATA_PHY_CFGTX3_OFFSET       (0x1128)

#define PHY_CFGRX0_VAL      0x008FCC22
#define PHY_CFGRX1_VAL      0x008E0500
#define PHY_CFGRX2_VAL      0x7BDEF000
#define PHY_CFGRX3_VAL      0x1F180B0F

#define PHY_CFGTX0_VAL      0x01003622
#define PHY_CFGTX1_VAL      0x40000002
#define PHY_CFGTX2_VAL      0x00C201F8
#define PHY_CFGTX3_VAL      0x073CE39E

#define CM_ALWON2_SATA0_CLKCTRL                (PRCM_BASE_ADDR + 0x560)
#define CM_ALWON2_L3_MED_SATA0_CLKSTCTRL    (PRCM_BASE_ADDR + 0x504)

#define CM_ALWON2_SATA1_CLKCTRL                (PRCM_BASE_ADDR + 0x554)
#define CM_ALWON2_L3_MED_SATA1_CLKSTCTRL    (PRCM_BASE_ADDR + 0x50C)


/********   PCIE PLL REGISTERS   **************/

#define PCIE_PLLCFG0            (CONTROL_BASE_ADDRESS+0x6D8)
#define PCIE_PLLCFG1            (CONTROL_BASE_ADDRESS+0x6DC)
#define PCIE_PLLCFG2            (CONTROL_BASE_ADDRESS+0x6E0)
#define PCIE_PLLCFG3            (CONTROL_BASE_ADDRESS+0x6E4)
#define PCIE_PLLCFG4            (CONTROL_BASE_ADDRESS+0x6E8)
#define PCIE_PLLSTATUS          (CONTROL_BASE_ADDRESS+0x6EC)
#define PCIE_RXSTATUS           (CONTROL_BASE_ADDRESS+0x6F0)
#define PCIE_TXSTATUS           (CONTROL_BASE_ADDRESS+0x6F4)
#define SERDES_REFCLK_CTL         (CONTROL_BASE_ADDRESS+0xE24)


#define CONTROL_STATUS              (CTRL_MODULE_BASE_ADDR + 0x040)
#define BANDGAP0_TRIM       (CTRL_MODULE_BASE_ADDR + 0x44C)
#define BANDGAP1_TRIM       (CTRL_MODULE_BASE_ADDR + 0x454)
#define PLL_SUBSYSTEM_BASE_ADDR       PLL_BASE_ADDRESS
#define IVAPLL_CLOCK_CONTROL       (PLL_SUBSYSTEM_BASE_ADDR + 0x0E4)
#define L3PLL_CLOCK_CONTROL        (PLL_SUBSYSTEM_BASE_ADDR + 0x114)
#define ISSPLL_CLOCK_CONTROL       (PLL_SUBSYSTEM_BASE_ADDR + 0x144)
#define DSSPLL_CLOCK_CONTROL       (PLL_SUBSYSTEM_BASE_ADDR + 0x174)
#define VID0PLL_CLOCK_CONTROL      (PLL_SUBSYSTEM_BASE_ADDR + 0x1A4)
#define VID1PLL_CLOCK_CONTROL      (PLL_SUBSYSTEM_BASE_ADDR + 0x1D4)
#define HDMIPLL_CLOCK_CONTROL      (PLL_SUBSYSTEM_BASE_ADDR + 0x204)
#define AUDIOPLL_CLOCK_CONTROL     (PLL_SUBSYSTEM_BASE_ADDR + 0x234)
#define USBPLL_CLOCK_CONTROL       (PLL_SUBSYSTEM_BASE_ADDR + 0x264)
#define DDRPLL_CLOCK_CONTROL       (PLL_SUBSYSTEM_BASE_ADDR + 0x294)
#define SABERTOOTHPLL_CLOCK_CONTROL (PLL_SUBSYSTEM_BASE_ADDR + 0x04C)



/*******************************************************************************************************
                               ********* RANGE ************

        REF_CLK       = (OSC_FREQ)/N+1  [  REF_CLK < 2.5MHz      ]
        DCOCLK_HS2    = (REF_CLK)*M     [500  < DCOCLK < 1000MHz ]
        DCOCLK_HS1    = (REF_CLK)*M     [1000 < DCOCLK < 2000MHz ] used for HDMI CLKDCO
        CLKOUT        =  DCOCLK/M2      [10   < CLKOUT < 2000MHz ]
        N+1                                   [1..256]
        M                                  [2..4095]
        M2                                  [1..127]

****************************************************************************************************
    Function used for configuring all ADPLLJ except Sabertooth
    ======================================================
    PLL_Clocks_Config(UWORD32 Base_Address,UWORD32 OSC_FREQ,UWORD32 N,UWORD32 M,UWORD32 M2,UWORD32 CLKCTRL_VAL)

      1. Pass the Base Address of the ADPLL to be configured.
      2. Pass the Clock i/p to the ADPLL as per the "defines" for ADPLL L3,video-0,video-1,audio,hdmi.
            OSC_0       -- Onchip  20MHz
            OSC_1       -- Offchip 27MHz
            For all other pll's iva,dss,usb,ddr clock i/p is fixed to OSC_0
      3. Configure N,M,M2 to get the desired clock o/p from ADPLLJ.
      4. Use the value CLKCTRL_VAL configured in the GEL file as per the defines mentioned above.

***********************************************************************************************
        CONFIGURED  ALL THE CLOCKS FOR ADPLL CLKi/p to 20MHz.

    ADPLL     CLKOUT    CLKDC0OUT    CLKLDO
    SABERTOOTH    600
    L3             220/200
    DSS            200
    IVA            266
    ISS            400
    USB            960       960         960
    VIDEO_0        54
    VIDEO_1       148.5
    AUDIO        200
    DDR           400/333
    HDMI           148.5     1485        148.5

******************************************************************************************************/

/******* CONFIGURE THE BELOW CLK I/P SOURCES  to OSC_0/OSC_1 FOR THE ADPLLJS ******/
#define L3_OSC_SRC           OSC_0
#define VIDE0_0_OSC_SRC       OSC_0
#define VIDE0_1_OSC_SRC       OSC_0
#define HDMI_OSC_SRC           OSC_0
#define AUDIO_OSC_SRC       OSC_0

//pass the below defines to L3_PLL_Config for configuring M value as per the L3 Clock Requirements
#define MVAL_L3_220     880
#define MVAL_L3_200     800  //audi_hd requirement

//pass the below defines to DDR_PLL_Config  for configuring M value as per the DDR Clock Requirements
#define MVAL_DDR_400     800
#define MVAL_DDR_333     666  //audi_hd requirement

#define CLKOUT2EN    1
#define CLKOUT2DIV   0
#define CLKOUT2SRC   0

// CLKOUT2DIV THis  field controls the external clock divison factor
//          0x0:      SYS_CLKOLUT2/1
//          0x1:      SYS_CLKOUT2/2
//          0x2:      SYS_CLKOUT2/4
//          0x3:      SYS_CLKOUT2/8
//          0x4:      SYS_CLKOUT2/16

// CLKOUT2SOURCE     This field selects the external output clock source
//          0x0:      Source clock is MAIN_PLL_CLK5
//          0x1:      Source clock is DDR_PLL_CLK1
//          0x2:      Source clock is VIDEO_PLL_CLK1
//          0x3:      Source clock is AUDIO_PLL_CLK1



#define control_pllss_mmr_lock                     0x481C5040
#define control_mmr_lock0                          0x48140060
#define control_mmr_lock1                          0x48140064
#define control_mmr_lock2                          0x48140068
#define control_mmr_lock3                          0x4814006c
#define control_mmr_lock4                          0x48140070

#define control_pllss_mmr_lock_unlock_val          0x1EDA4C3D
#define control_mmr_lock0_unlock_val               0x2FF1AC2B
#define control_mmr_lock1_unlock_val               0xF757FDC0
#define control_mmr_lock2_unlock_val               0xE2BC3A6D
#define control_mmr_lock3_unlock_val               0x1EBF131D
#define control_mmr_lock4_unlock_val               0x6F361E05


#define DM385_TEST_DEVICE_FW_VAL 0xFFFFFFFF
/*DM385 Fire Wall Registers*/

#define EMIF_FW             0x47C0C088
#define GPMC_FW             0x47C0E088
#define OCMC_RAM0_FW         0x47C10088
#define DUCATI_FW             0x47C18088
#define PCIE_FW                0x47C1A088
#define IVAHD_SL2_FW         0x47C1E088
#define IVAHD_CFG_FW         0x47C20088
#define ISS_FW                 0x47C26088
#define MCASP_FW             0x47C28088
#define SecuritySS_FW         0x47C2A088
#define HDMI_FW             0x47C2C088
#define TPTC_FW             0x47C30088
#define TPCC_FW             0x47C38088
#define USB_FW                 0x47C3A088

/*********** SABERTOOTH ADPLLS REGISTERS  *********/
#define SABERTOOTHPLL_CLKCTRL        (PLL_BASE_ADDRESS+0x04c)
#define SABERTOOTHPLL_TENABLE        (PLL_BASE_ADDRESS+0x050)
#define SABERTOOTHPLL_TENABLEDIV    (PLL_BASE_ADDRESS+0x054)
#define SABERTOOTHPLL_M2NDIV        (PLL_BASE_ADDRESS+0x058)
#define SABERTOOTHPLL_MN2DIV        (PLL_BASE_ADDRESS+0x05c)
#define SABERTOOTHPLL_STATUS        (PLL_BASE_ADDRESS+0x06c)

/***DDR3 **/
/*Added for vga support*/
#define    DDR3_EMIF_READ_LATENCY_DEFINE	0xC
/*end*/
#define ONE_GB 1
#define TWO_GB 2

/*****************************************************************************/
/*EMIF4 PRCM Defintion*/
#define CM_DEFAULT_L3_FAST_CLKSTCTRL                (PRCM_BASE_ADDR + 0x0508)
#define CM_DEFAULT_EMIF_0_CLKCTRL               (PRCM_BASE_ADDR + 0x0520)
#define CM_DEFAULT_DMM_CLKCTRL                  (PRCM_BASE_ADDR + 0x0528)
#define CM_DEFAULT_FW_CLKCTRL                   (PRCM_BASE_ADDR + 0x052C)
/*end of EMIF4 PRCM definition*/

#define DDR0_PHY_BASE_ADDR                  0x47C0C400
#define DDR0_IO_CTRL                        0x48140E04
#define VTP0_CTRL_REG                       0x48140E0C
#define EMIF4_0_CFG_BASE_ADDR               0x4C000000
#define DMM_BASE_ADDR                       0x4E000000

//-DMM & EMIF4 MMR Declaration
#define DMM_LISA_MAP__0                     (DMM_BASE_ADDR + 0x40)
#define DMM_LISA_MAP__1                     (DMM_BASE_ADDR + 0x44)
#define DMM_LISA_MAP__2                     (DMM_BASE_ADDR + 0x48)
#define DMM_LISA_MAP__3                     (DMM_BASE_ADDR + 0x4C)
#define DMM_PAT_BASE_ADDR                   (DMM_BASE_ADDR + 0x460)

#define EMIF4_0_SDRAM_CONFIG                    (EMIF4_0_CFG_BASE_ADDR + 0x08)
#define EMIF4_0_SDRAM_CONFIG2                   (EMIF4_0_CFG_BASE_ADDR + 0x0C)
#define EMIF4_0_SDRAM_REF_CTRL                  (EMIF4_0_CFG_BASE_ADDR + 0x10)
#define EMIF4_0_SDRAM_REF_CTRL_SHADOW               (EMIF4_0_CFG_BASE_ADDR + 0x14)
#define EMIF4_0_SDRAM_TIM_1                 (EMIF4_0_CFG_BASE_ADDR + 0x18)
#define EMIF4_0_SDRAM_TIM_1_SHADOW              (EMIF4_0_CFG_BASE_ADDR + 0x1C)
#define EMIF4_0_SDRAM_TIM_2                 (EMIF4_0_CFG_BASE_ADDR + 0x20)
#define EMIF4_0_SDRAM_TIM_2_SHADOW              (EMIF4_0_CFG_BASE_ADDR + 0x24)
#define EMIF4_0_SDRAM_TIM_3                 (EMIF4_0_CFG_BASE_ADDR + 0x28)
#define EMIF4_0_SDRAM_TIM_3_SHADOW              (EMIF4_0_CFG_BASE_ADDR + 0x2C)
#define EMIF4_0_DDR_PHY_CTRL_1                  (EMIF4_0_CFG_BASE_ADDR + 0xE4)
#define EMIF4_0_DDR_PHY_CTRL_1_SHADOW               (EMIF4_0_CFG_BASE_ADDR + 0xE8)
#define EMIF4_0_SDRAM_ZQCR                  (EMIF4_0_CFG_BASE_ADDR + 0xC8)
#define EMIF4_0_RDWR_LVL_RMP_CTRL               (EMIF4_0_CFG_BASE_ADDR + 0xD8)
#define EMIF4_0_RDWR_LVL_CTRL                   (EMIF4_0_CFG_BASE_ADDR + 0xDC)


/*Added*/
#define EMIF4_1_SDRAM_CONFIG			(EMIF4_0_CFG_BASE_ADDR + 0xE8)
#define EMIF4_1_SDRAM_CONFIG2			(EMIF4_0_CFG_BASE_ADDR + 0xEC)
#define EMIF4_1_SDRAM_REF_CTRL			(EMIF4_0_CFG_BASE_ADDR + 0xF0)
#define EMIF4_1_SDRAM_REF_CTRL_SHADOW	(EMIF4_0_CFG_BASE_ADDR + 0xF4)
#define EMIF4_1_SDRAM_TIM_1				(EMIF4_0_CFG_BASE_ADDR + 0xFC)
#define EMIF4_1_SDRAM_TIM_1_SHADOW		(EMIF4_0_CFG_BASE_ADDR + 0x100)
#define EMIF4_1_SDRAM_TIM_2				(EMIF4_0_CFG_BASE_ADDR + 0x104)
#define EMIF4_1_SDRAM_TIM_2_SHADOW		(EMIF4_0_CFG_BASE_ADDR + 0x108)
#define EMIF4_1_SDRAM_TIM_3				(EMIF4_0_CFG_BASE_ADDR + 0x10C)
#define EMIF4_1_SDRAM_TIM_3_SHADOW		(EMIF4_0_CFG_BASE_ADDR + 0x110)
#define EMIF4_1_DDR_PHY_CTRL_1			(EMIF4_0_CFG_BASE_ADDR + 0x114)
#define EMIF4_1_DDR_PHY_CTRL_1_SHADOW	(EMIF4_0_CFG_BASE_ADDR + 0x118)
#define EMIF4_1_IODFT_TLGC			    (EMIF4_0_CFG_BASE_ADDR + 0x11C)
#define EMIF4_1_RDWR_LVL_RMP_CTRL       (EMIF4_0_CFG_BASE_ADDR + 0x120)
#define EMIF4_1_RDWR_LVL_CTRL           (EMIF4_0_CFG_BASE_ADDR + 0x124)
/*end*/

//- DDR0 Phy MMRs
#define CMD0_REG_PHY0_CTRL_SLAVE_RATIO_0            (0x01C + DDR0_PHY_BASE_ADDR)
#define CMD0_REG_PHY0_DLL_LOCK_DIFF_0               (0x028 + DDR0_PHY_BASE_ADDR)
#define CMD0_REG_PHY0_INVERT_CLKOUT_0               (0x02C + DDR0_PHY_BASE_ADDR)
#define CMD1_REG_PHY0_CTRL_SLAVE_RATIO_0            (0x050 + DDR0_PHY_BASE_ADDR)
#define CMD1_REG_PHY0_DLL_LOCK_DIFF_0               (0x05C + DDR0_PHY_BASE_ADDR)
#define CMD1_REG_PHY0_INVERT_CLKOUT_0               (0x060 + DDR0_PHY_BASE_ADDR)
#define CMD2_REG_PHY0_CTRL_SLAVE_RATIO_0            (0x084 + DDR0_PHY_BASE_ADDR)
#define CMD2_REG_PHY0_DLL_LOCK_DIFF_0               (0x090 + DDR0_PHY_BASE_ADDR)
#define CMD2_REG_PHY0_INVERT_CLKOUT_0               (0x094 + DDR0_PHY_BASE_ADDR)

#define DATA0_REG_PHY0_RD_DQS_SLAVE_RATIO_0         (0x0C8 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WR_DQS_SLAVE_RATIO_0         (0x0DC + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WRLVL_INIT_RATIO_0           (0x0F0 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WRLVL_INIT_MODE_0            (0x0F8 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_GATELVL_INIT_RATIO_0             (0x0FC + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_GATELVL_INIT_MODE_0          (0x104 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_RD_DQS_GATE_SLAVE_RATIO_0            (0x108 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_WR_DATA_SLAVE_RATIO_0            (0x120 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_USE_RANK0_DELAYS             (0x134 + DDR0_PHY_BASE_ADDR)
#define DATA0_REG_PHY0_DLL_LOCK_DIFF_0              (0x138 + DDR0_PHY_BASE_ADDR)

#define DATA1_REG_PHY0_RD_DQS_SLAVE_RATIO_0             (0x16C + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WR_DQS_SLAVE_RATIO_0             (0x180 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WRLVL_INIT_RATIO_0           (0x194 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WRLVL_INIT_MODE_0            (0x19C + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_GATELVL_INIT_RATIO_0             (0x1A0 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_GATELVL_INIT_MODE_0          (0x1A8 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_RD_DQS_GATE_SLAVE_RATIO_0            (0x1AC + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_WR_DATA_SLAVE_RATIO_0            (0x1C4 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_USE_RANK0_DELAYS             (0x1D8 + DDR0_PHY_BASE_ADDR)
#define DATA1_REG_PHY0_DLL_LOCK_DIFF_0              (0x1DC + DDR0_PHY_BASE_ADDR)

#define DATA2_REG_PHY0_RD_DQS_SLAVE_RATIO_0             (0x210 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WR_DQS_SLAVE_RATIO_0             (0x224 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WRLVL_INIT_RATIO_0           (0x238 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WRLVL_INIT_MODE_0            (0x240 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_GATELVL_INIT_RATIO_0             (0x244 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_GATELVL_INIT_MODE_0          (0x24C + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_RD_DQS_GATE_SLAVE_RATIO_0            (0x250 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_WR_DATA_SLAVE_RATIO_0            (0x268 + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_USE_RANK0_DELAYS             (0x27C + DDR0_PHY_BASE_ADDR)
#define DATA2_REG_PHY0_DLL_LOCK_DIFF_0              (0x280 + DDR0_PHY_BASE_ADDR)

#define DATA3_REG_PHY0_RD_DQS_SLAVE_RATIO_0             (0x2B4 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WR_DQS_SLAVE_RATIO_0             (0x2C8 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WRLVL_INIT_RATIO_0           (0x2DC + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WRLVL_INIT_MODE_0            (0x2E4 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_GATELVL_INIT_RATIO_0             (0x2E8 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_GATELVL_INIT_MODE_0          (0x2F0 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_RD_DQS_GATE_SLAVE_RATIO_0            (0x2F4 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_WR_DATA_SLAVE_RATIO_0            (0x30C + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_USE_RANK0_DELAYS             (0x320 + DDR0_PHY_BASE_ADDR)
#define DATA3_REG_PHY0_DLL_LOCK_DIFF_0              (0x324 + DDR0_PHY_BASE_ADDR)


#define DATA_MACRO_0                            0
#define DATA_MACRO_1                            1
#define DATA_MACRO_2                            2
#define DATA_MACRO_3                            3
#define DDR_PHY0                        0


//- Common DDR PHY parameters
#define PHY_INVERT_CLKOUT_DEFINE                0
#define DDR3_PHY_INVERT_CLKOUT_ON               1
#define DDR3_PHY_INVERT_CLKOUT_OFF              0

#define PHY_REG_USE_RANK0_DELAY_DEFINE              0
#define mDDR_PHY_REG_USE_RANK0_DELAY_DEFINE         1
#define PHY_DLL_LOCK_DIFF_DEFINE                    0x4
#define PHY_CMD0_DLL_LOCK_DIFF_DEFINE               0x4

#define PHY_GATELVL_INIT_CS0_DEFINE                     0x0
#define PHY_WRLVL_INIT_CS0_DEFINE               0x0

#define PHY_GATELVL_INIT_CS1_DEFINE                     0x0
#define PHY_WRLVL_INIT_CS1_DEFINE               0x0
#define PHY_CTRL_SLAVE_RATIO_CS1_DEFINE                 0x80
/*Added for VGA Support*/
#define	   DDR3_PHY_INVERT_CLKOUT_DEFINE	 0

//- DDR3 parameters

#define    DDR3_EMIF_REF_CTRL_DEFINE1            0x00004000
#define    DDR3_EMIF_SDRAM_ZQCR_DEFINE              0x50074BE1


//DDR3 300 MHz - CL=5,CWL=5 , RL=CL+3
#define    DDR3_EMIF_TIM1_DEFINE_300                0x1109783B
#define    DDR3_EMIF_TIM2_DEFINE_300                0x20327FDA
#define    DDR3_EMIF_TIM3_DEFINE_300                0x501F86AF
#define    DDR3_EMIF_REF_CTRL_DEFINE2_300           0x00000924
#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_300        0x61C009B2
#define    DDR3_EMIF_DDRPHYCR_DEFINE_300            0x00173207

//DDR3 333 MHz - CL=6,CWL=5, RL=CL+3
#define    DDR3_EMIF_TIM1_DEFINE_333                0x1109783B
#define    DDR3_EMIF_TIM2_DEFINE_333                0x20387FDA
#define    DDR3_EMIF_TIM3_DEFINE_333                0x501F86AF
#define    DDR3_EMIF_REF_CTRL_DEFINE2_333           0x00000A25
#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_333        0x61C011B2
#define    DDR3_EMIF_DDRPHYCR_DEFINE_333            0x00173208

//DDR3 400 MHz - CL=6,CWL=5, RL=CL+3
//#define    DDR3_EMIF_TIM1_DEFINE_400                0x110B783B
//#define    DDR3_EMIF_TIM2_DEFINE_400                0x20437FDA
//#define    DDR3_EMIF_TIM3_DEFINE_400                0x501F86AF
//#define    DDR3_EMIF_REF_CTRL_DEFINE2_400           0x00000C30
//#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_400        0x61C011B2
//#define    DDR3_EMIF_DDRPHYCR_DEFINE_400            0x00173208

//DDR3 450 MHz - CL=7,CWL=6, RL=CL+3
#define    DDR3_EMIF_TIM1_DEFINE_450                0x110D783B
#define    DDR3_EMIF_TIM2_DEFINE_450                0x204C7FDA
#define    DDR3_EMIF_TIM3_DEFINE_450                0x501F86AF
#define    DDR3_EMIF_REF_CTRL_DEFINE2_450           0x00000DB6
#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_450        0x61C119B2
#define    DDR3_EMIF_DDRPHYCR_DEFINE_450            0x00173209

//DDR3 533 MHz - CL=8,CWL=6, RL=CL+3
#define    DDR3_EMIF_TIM1_DEFINE_533                0x110F783B
#define    DDR3_EMIF_TIM2_DEFINE_533                0x238581E6
#define    DDR3_EMIF_TIM3_DEFINE_533                0x501F86AF
#define    DDR3_EMIF_REF_CTRL_DEFINE2_533           0x0000103D
#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_533        0x61C121B2
#define    DDR3_EMIF_DDRPHYCR_DEFINE_533            0x0017320A

//DDR3 666 MHz - CL=9,CWL=7, RL=CL+3
#define    DDR3_EMIF_TIM1_DEFINE_666                0x1113783C
#define    DDR3_EMIF_TIM2_DEFINE_666                0x30611d94
#define    DDR3_EMIF_TIM3_DEFINE_666                0x501F86AF
#define    DDR3_EMIF_REF_CTRL_DEFINE2_666           0x0000144A
#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_666        0x61C229B2
#define    DDR3_EMIF_DDRPHYCR_DEFINE_666            0x0017320B

//DDR3L 400 MHz - CL=6,CWL=5, RL=CL+3
//#define    DDR3_EMIF_TIM1_DEFINE_400                0x0AAAC463
//#define    DDR3_EMIF_TIM2_DEFINE_400                0x202F7FDA
//#define    DDR3_EMIF_TIM3_DEFINE_400                0x507F829F
//#define    DDR3_EMIF_REF_CTRL_DEFINE2_400           0x00000618
//#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_400        0x61C11A32
//#define    DDR3_EMIF_DDRPHYCR_DEFINE_400            0x00170209


//DDR3L 400 MHz - CL=6,CWL=5, RL=CL+3
#define    DDR3_EMIF_TIM1_DEFINE_400                0x0AAAD4F3
#define    DDR3_EMIF_TIM2_DEFINE_400                0x206B7FDA
#define    DDR3_EMIF_TIM3_DEFINE_400                0x507F869F
#define    DDR3_EMIF_REF_CTRL_DEFINE2_400           0x00000C30
#define    DDR3_EMIF_SDRAM_CONFIG_DEFINE_400        0x61C11A32
#define    DDR3_EMIF_DDRPHYCR_DEFINE_400            0x00170209

#define    DDR3_PHY_CTRL_SLAVE_RATIO_CS0_DEFINE         0x80

#define    DDR3_PHY_RD_DQS_CS0_DEFINE               0x34
#define    DDR3_PHY_WR_DQS_CS0_DEFINE               0xF
#define    DDR3_PHY_RD_DQS_GATE_CS0_DEFINE          0x6A
#define    DDR3_PHY_WR_DATA_CS0_DEFINE              0x44
/*  End of DDR3 Registers */

/*
 *====================
 * Function declaration
 *====================
*/

/** **************************************************************************
 * \n \brief Micro-second delay routine
 *
 * Utility routine for micro-seconds
 * 
 * \param  u32usec	[IN] 	Delay in micro-seconds
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
extern void DM388_usecDelay
( 
	UINT32 u32usec 
);
/** **************************************************************************
 * \n \brief Routine to initialize the DM388 EVM board
 *
 * This routine initializes the DM388 EVM Base Board
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
INT32 DM388_Init (void);

void DM388_wait(UINT32 u32Delay );

void init_delay(void);

void wait_delay(UWORD32 noopcount);

void ControlModule_ClkEnable(void);

void Unlock_PLL_Control_MMR(void);

void OpenFireWall(void);

void ALL_ADPLL_CLOCKS_ENABLE_API(void);

void EMACClkEnable(void);

void PLL_SETUP(void);

void cmdMPUPLL(int CLKIN,int N, int M, int M2);

void SABERTOOTH_PLL_Config(UWORD32 CLKIN,UWORD32 N,UWORD32 M,UWORD32 M2);

void cmdL3PLL(int CLKIN,int N, int M, int M2);

void cmdDSSPLL(int CLKIN, int N, int M, int M2);

void cmdIVAPLL(int CLKIN,int N, int M, int M2);

void cmdISSPLL(int CLKIN,int N, int M, int M2);

void cmdUSBPLL(int CLKIN,int N, int M, int M2);

void cmdVIDEO0PLL(int CLKIN,int N, int M, int M2);

void cmdVIDEO1PLL(int CLKIN,int N, int M, int M2);

void cmdHDMIPLL(int CLKIN,int N, int M, int M2);

void cmdDDRPLL(int CLKIN,int N, int M, int M2);

void cmdAUDIOPLL(int CLKIN,int N, int M, int M2);

void SATA_PLL_Config(void);

void DDR3_Initialization(void);

void  DDR3_Init_400MHz_Config(void);

void  DDR3_Init_533MHz_Config(void);

void cmd_DDR3_EMIF0_Config(UWORD32 ddr3_phy_rd_dqs_cs0_arg,UWORD32 ddr3_phy_wr_dqs_cs0_arg,UWORD32 ddr3_phy_rd_dqs_gate_cs0_arg,UWORD32 ddr3_phy_wr_data_cs0_arg,UWORD32 ddr3_emif_read_latency_arg,UWORD32 ddr3_emif_tim1_arg,UWORD32 ddr3_emif_tim2_arg,UWORD32 ddr3_emif_tim3_arg,UWORD32 ddr3_emif_ref_ctrl_arg,UWORD32 ddr3_emif_sdram_config_arg);

void Emif_PRCM_Clk_Enable(void);

void Cmd_Macro_Config(UWORD32 ddr_phy_num,UWORD32 invert_clk_out,UWORD32 ctrl_slave_ratio_cs0,UWORD32 cmd_dll_lock_diff);

void Data_Macro_Config(UWORD32 dataMacroNum,UWORD32 ddr_phy_num,UWORD32 rd_dqs_cs0,UWORD32 wr_dqs_cs0,UWORD32 rd_dqs_gate_cs0,UWORD32 wr_data_cs0);

void Vtp_Enable(void);

void Emif0_MMR_Config(UWORD32 read_latency,UWORD32 tim1,UWORD32 tim2,UWORD32 tim3,UWORD32 ref_ctrl,UWORD32 sdram_config);

void DCOCLK_COMP(int CLKIN,int N, int M);

void PLL_Clocks_Config(UWORD32 Base_Address,UWORD32 CLKIN,UWORD32 N,UWORD32 M,UWORD32 M2,UWORD32 CLKCTRL_VAL);

void GPMCClkEnable(void);

void NANDInit(void);

void Aic3104Init(void);

void I2C0Enable(void);

void I2C2Enable(void);

void MCA1ClkEnable(void);

void BTInit(void);

void GPIO0ClkEnable(void);

void GPIO1ClkEnable(void);

void GPIO2ClkEnable(void);

void UARTClkEnable(void);

void DM385_System_Initialisation_TEST_device(void);

void DucatiClkEnable(void);

void IVAHD0ClkEnable(void);

void EthernetInit(void);

void Ethernet_PinMux_Setup(void);

void HDMI_Video_Init (void);

void VIDEO_0_PLL_Config(void);

void VIDEO_1_PLL_Config(void);

void DSSClkEnable(void);

void hdmipinmux_cec_ddc(void);

void configure_hdmi_phy(void);

void configure_hdvenc_1080p60(void);

void LEDInit(void);

void SDMMCInit(void);

void MMC0ClkEnable(void);

void MMC1ClkEnable(void);

void SwitchInit(void);

void MCA0ClkEnable(void);

void USBInit(void);

void USBClkEnable(void);

void DM388_WLANInit(void);

/* @} */   /* End of EVM */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM388_EVM_H_ */
